#line 1 "C:/Documents and Settings/Imajeenyus/Desktop/2014-01-09 Digimatic interface + analogue display/Final PIC program/digimatic.c"
#line 1 "c:/program files/mikroelektronika/mikroc pro for pic/include/built_in.h"
#line 12 "C:/Documents and Settings/Imajeenyus/Desktop/2014-01-09 Digimatic interface + analogue display/Final PIC program/digimatic.c"
sbit SPC_DATA at PORTC.B0;
sbit SPC_CLOCK at PORTC.B1;
sbit SPC_REQ at PORTC.B2;
sbit SET_ZERO at PORTC.B3;
sbit SET_RANGE at PORTC.B4;
signed int current_spc_value;
signed int zero_value;


char txt7[7];



void update_meter(signed long int lrw_value)
{
 unsigned int pwm_value;
 lrw_value*=512;
 lrw_value/=100;
 if(lrw_value<-512) {lrw_value=-512;}
 else if(lrw_value>511) {lrw_value=511;}
 pwm_value=512+lrw_value;
 CCPR1L=(pwm_value >> 2) & 255;
 DC1B1_bit= ((char *)&lrw_value)[0] .B1;
 DC1B0_bit= ((char *)&lrw_value)[0] .B0;
}



signed int read_spc()
{



 unsigned short int recdata[14]={0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 unsigned short int digit;
 signed int result;


 SPC_REQ=1;


 for(digit=1;digit<14;digit++)
 {
 while (SPC_CLOCK==1);
 recdata[digit].B0=SPC_DATA;
 while (SPC_CLOCK==0);
 while (SPC_CLOCK==1);
 recdata[digit].B1=SPC_DATA;
 while (SPC_CLOCK==0);
 while (SPC_CLOCK==1);
 recdata[digit].B2=SPC_DATA;
 while (SPC_CLOCK==0);
 while (SPC_CLOCK==1);
 recdata[digit].B3=SPC_DATA;
 while (SPC_CLOCK==0);
 }


 SPC_REQ=0;


 result=(recdata[8]*1000)+(recdata[9]*100)+(recdata[10]*10)+recdata[11];
 if (recdata[5]==8) {result*=-1;}


 return result;
}

void main() {


 ANSEL=0;
 ANSELH=0;
 TRISC=0b00011011;
 PORTC=0;


 TRISC.B5=1;
 PR2=255;
 CCP1CON=0b00001100;
 CCPR1L=0;
 TMR2IF_bit=0;
 T2CON=0b00000011;
 TMR2ON_bit=1;
 while (TMR2IF_bit==0) {}
 TRISC.B5=0;


 UART1_Init(9600);
 Delay_ms(100);


 UART1_Write_Text("Digimatic readout interface 08/01/14");
 UART1_Write(13);
 UART1_Write(13);


 update_meter(0);


 zero_value=0;







 while (1)
 {

 current_spc_value=read_spc();


 if(SET_ZERO) {zero_value=current_spc_value;}


 if(SET_RANGE) {update_meter(current_spc_value-zero_value);}
 else {update_meter((current_spc_value-zero_value)*10);}


 IntToStr(read_spc(),txt7);
 UART1_Write_Text(txt7);
 UART1_Write_Text(",");
 IntToStr(current_spc_value-zero_value,txt7);
 UART1_Write_Text(txt7);
 uart1_write(13);


 Delay_ms(50);

 }
}
